
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   ZLOG.C - Zodiac Log Message Processing
// 
//
//   DESCRIPTION
//
//   Functions to build and decode Zodiac log control messages.
//
//
//   REVISION HISTORY
//
//   $Log:   V:\Projects\Labmon\Source\Archives\ZLOG.C_V  $
//   
//      Rev 1.15   09 Nov 1998 10:48:14   phungh
//   labmon51: Fix file logging and missing
//   logged data bugs.  Changes made to the 
//   "Pause" variable ( 1 -> 0 ) to allow main
//   loop continue.  Move the "write to file"
//   code portion out of the interrupt handler
//   so that data is not missed because of time
//   spent too long in the interrupt handler
//   
//      Rev 1.3   Jul 09 1997 10:59:32   COLEJ
//    
//   
//      Rev 1.2   Feb 12 1997 16:06:00   COLEJ
//    
//   
//      Rev 1.1   Aug 13 1996 15:22:38   COLEJ
//    
//   
//      Rev 1.0   13 May 1996 14:53:26   GPSADMIN
//   Initial release to version control.
//
//
////////////////////////////////////////////////////////////////////////////////
 
#include <stdio.h>
#include <graph.h>
#include <string.h>
#include <math.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"


////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac Log message from the ZMsgBuf.
//
void DecZLog(tMSGBUF *ZMsgBuf, tZLOG *Msg)
{  
   GetShort  (&Msg->MsgTrigger              , ZMsgBuf, 6);    // message trigger
   GetShort  (&Msg->MsgInterval             , ZMsgBuf, 7);    // message interval 
   GetShort  (&Msg->MsgOffset               , ZMsgBuf, 8);    // message offset 
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac Query message in the ZMsgBuf. 
//
void BldZLog(tMSGBUF *ZMsgBuf, tZLOG *Msg)
{
   PutShort  (0x81FF                       , ZMsgBuf, 1);    // message preamble
   PutShort  (Msg->MsgID                   , ZMsgBuf, 2);    // message number
   PutShort  (3                            , ZMsgBuf, 3);    // message length 
   PutShort  (Msg->MsgFlags                , ZMsgBuf, 4);    // message ack/nack
 //PutShort  (CheckSum(ZMsgBuf[0], 4)      , ZMsgBuf, 5);    // header check sum 
   
   PutLong   (Msg->MsgTrigger              , ZMsgBuf, 6);    // message trigger
   PutLong   (Msg->MsgInterval             , ZMsgBuf, 7);    // message interval 
   PutLong   (Msg->MsgOffset               , ZMsgBuf, 8);    // message offset
 
 //PutShort  (CheckSum(ZMsgBuf, 3, 6 )     , ZMsgBuf, 9);   // data check sum 
}

     
